/*:
 * @target MZ
 * @author KuiMoiyri
 */

(() => {
    Ve = Ve || {};
    Ve.params = Ve.params || {};

    Ve.TimePuzzle = {};

    Ve.TimePuzzle.numMap = {
        0: 'XII',
        1: 'I',
        2: 'II',
        3: 'III',
        4: 'IV',
        5: 'V',
        6: 'VI',
        7: 'VII',
        8: 'VIII',
        9: 'IX',
        10: 'X',
        11: 'XI',
        12: 'XII'
    };

    Ve.TimePuzzle.clamp = function (value, min, max) {
        return Math.max(min, Math.min(max, value));
    };

    Ve.TimePuzzle.setTime = function (time) {
        $gameVariables.setValue(51, Ve.TimePuzzle.clamp(time, 1, 12));
    }

    Ve.TimePuzzle.getTime = function () {
        return $gameVariables.value(51);
    }

    Ve.TimePuzzle.resetTime = function () {
        $gameVariables.setValue(51, 1);
    }

    Ve.TimePuzzle.timeAction = function (action) {
        $gameVariables.setValue(57, action);
    }

    Ve.TimePuzzle.timePosition = function () {
        $gameVariables.setValue(56, [$gameMap.mapId(), $gamePlayer.x, $gamePlayer.y, $gamePlayer.direction()]);
    }

    Ve.TimePuzzle.getPosition = function () {
        return $gameVariables.value(56);
    }

    Ve.TimePuzzle.positionAvalible = function () {
        try {
            const time = $gameVariables.value(56);
            return time[0] >= 1 || time[1] >= 0 || time[2] >= 0 || time[3] >= 0;
        } catch (e) {
            return false;
        }

    }

    Ve.TimePuzzle.actionAvalible = function () {
        const action = $gameVariables.value(57);
        if (action === 'none') {
            return false;
        } else if (action === 'item' || action === 'interact' || action === 'idle') {
            return true;
        } else {
            $gameVariables.setValue('none');
        }

    }

    Ve.TimePuzzle.timeWithShadow = function () {
        return $gameVariables.value(59);
    }

    Ve.TimePuzzle.setTimeWithShadow = function (time) {
        return $gameVariables.setValue(59, time);
    }

    Ve.TimePuzzle.checkShadow = function () {
        return $gameVariables.value(60).time >= 0;
    }
})();