/*:
 * @target MZ
 * @author KuiMoiyri
 * 
 * @param widgets
 * @type struct<floatWidget>[]
 */


/*~struct~floatWidget:
 * @param image
 * @type file
 * @dir img/ui
 * 
 * @param regionId
 * @type number
 * 
 * @param conditions
 * @type multiline_string
 * @default true
 * 
 * @param tag
 * @type string
 */

(() => {
    Liy = Liy || {};

    Ve = Ve || {};
    Ve.params = Ve.params || {};
    Ve.FloatWidgets = {}

    Ve.FloatWidgets.offsetX = -1
    Ve.FloatWidgets.offsetY = -40;

    const pluginName = "Ve_2_FloatWidgets"
    const params = PluginManager.parameters(pluginName);

    Ve.params.floatWidgets = JSON.parse(JSON.stringify(params["widgets"],
        Liy.Utils.paramJsonParse))

    function Sprite_FloatWidget() {
        this.initialize.apply(this, arguments);
    }

    Sprite_FloatWidget.prototype = Object.create(Sprite.prototype);
    Sprite_FloatWidget.prototype.constructor = Sprite_FloatWidget;

    Sprite_FloatWidget.prototype.initialize = function () {
        Sprite.prototype.initialize.call(this);
        this.opacity = 0;
        this._regionId = 0;
        this._canDisplay = false;
        this._tag = '';
        this.z = -100;
        this._animeOffsetY = 16;
        this._animeOriginY = 16;
        this.showConditions = null;
        this.scale.x = 1 / $gameScreen.zoomScale();
        this.scale.y = 1 / $gameScreen.zoomScale();
        this.update();
    }

    Sprite_FloatWidget.prototype.update = function () {
        this.updateDislay();
    }

    Sprite_FloatWidget.prototype.updateDislay = function () {
        // const playerRegion = $gameMap.regionId($gamePlayer.x, $gamePlayer.y);
        const event = $gameMap._events[$gamePlayer.getFacingEvent(true)];
        const eventBelow = $gameMap._events[$gamePlayer.getEventBelow()];

        if(event) {
            this._canDisplay = event.checkTipCode(this._tag);
            if(!this._canDisplay && eventBelow) {
                this._canDisplay = eventBelow.checkTipCode(this._tag);
            }
        } else {
            this._canDisplay = false;
        }

        this.x = $gamePlayer.screenX() + 20 - this.width / 2 + Ve.FloatWidgets.offsetX;
        this.y = $gamePlayer.screenY() - this.height + Ve.FloatWidgets.offsetY + this._animeOffsetY;

        this.updateShow();
        this.updateHide();
    }

    Sprite_FloatWidget.prototype.updateShow = function () {
        if (this._canDisplay) {
            if (!this.isShow()) {
                // this.opacity = 255;
                this.opacity += (255 - this.opacity) * 0.2;
                if (this.opacity > 253) this.opacity = 255;
                this._animeOffsetY = this._animeOriginY * (1 - this.opacity / 255);
            }
        }
    }

    Sprite_FloatWidget.prototype.updateHide = function () {
        if (!this._canDisplay) {
            if (!this.isHidden()) {
                // this.opacity = 0;
                this.opacity -= this.opacity * 0.2;
                if (this.opacity < 2) this.opacity = 0;
                this._animeOffsetY = this._animeOriginY * (1 - this.opacity / 255);
            }
        }
    }

    Sprite_FloatWidget.prototype.isShow = function () {
        return this.opacity >= 255;
    }

    Sprite_FloatWidget.prototype.isHidden = function () {
        return this.opacity <= 0;
    }

    Sprite_FloatWidget.prototype.loadBitmap = function (filename) {
        this.bitmap = ImageManager.loadBitmap("img/ui/", filename);
    }

    Sprite_FloatWidget.prototype.setRegion = function (regionId) {
        this._regionId = regionId;
    }

    Sprite_FloatWidget.prototype.setConditions = function (condition) {
        this.showConditions = condition;
    }

    Sprite_FloatWidget.prototype.setTag = function(tag) {
        this._tag = tag;
    }

    // Ve.FloatWidgets._Scene_Map_prototype_initialize =
    //     Scene_Map.prototype.initialize
    // Scene_Map.prototype.initialize = function () {
    //     Ve.FloatWidgets._Scene_Map_prototype_initialize.call(this);
    //     this._floatWidgets = [];
    // }

    // Ve.FloatWidgets._Scene_Map_prototype_createDisplayObjects =
    //     Scene_Map.prototype.createDisplayObjects;
    // Scene_Map.prototype.createDisplayObjects = function () {
    //     Ve.FloatWidgets._Scene_Map_prototype_createDisplayObjects.call(this);
    //     this.createFloatWidgets();
    // }

    Ve.FloatWidgets._Spriteset_Base_prototype_initialize = Spriteset_Base.prototype.initialize;
    Spriteset_Base.prototype.initialize = function() {
        Ve.FloatWidgets._Spriteset_Base_prototype_initialize.call(this);
        this._floatWidgets = [];
    }

    Ve.FloatWidgets._Spriteset_Base_prototype_createUpperLayer = Spriteset_Base.prototype.createUpperLayer;
    Spriteset_Map.prototype.createUpperLayer = function() {
        this.createFloatWidgets(); 
        Ve.FloatWidgets._Spriteset_Base_prototype_createUpperLayer.call(this);
    }

    Spriteset_Base.prototype.createFloatWidgets = function() {
        const floatWidgets = Ve.params.floatWidgets;
        for (widget of floatWidgets) {
            const regionId = widget.regionId;
            const widgetBitmap = widget.image;
            const showConditions = widget.conditions;
            const tag = widget.tag;
            const widgetSprite = new Sprite_FloatWidget();
            widgetSprite.loadBitmap(widgetBitmap);
            widgetSprite.setRegion(regionId);
            widgetSprite.setConditions(showConditions);
            widgetSprite.setTag(tag);

            // this._floatWidgets.push(widgetSprite);
            this.addChild(widgetSprite);
        }
    }

    Scene_Map.prototype.createFloatWidgets = function () {
        const floatWidgets = Ve.params.floatWidgets;
        for (widget of floatWidgets) {
            const regionId = widget.regionId;
            const widgetBitmap = widget.image;
            const showConditions = widget.conditions;
            const tag = widget.tag;
            const widgetSprite = new Sprite_FloatWidget();
            widgetSprite.loadBitmap(widgetBitmap);
            widgetSprite.setRegion(regionId);
            widgetSprite.setConditions(showConditions);
            widgetSprite.setTag(tag);

            this._floatWidgets.push(widgetSprite);
            this.addChild(widgetSprite);
        }
    }
})();