/*:
 * @target MZ
 * @author KuiMoiyri
 * 
 * @param useCustomWindow
 * @type boolean
 * @default true
 * 
 * @param windowBgAnimeOffsetX
 * @type number
 * @default 0
 * 
 * @param windowBgAnimeOffsetY
 * @type number
 * @default 200
 * 
 * @param windowDimmerOffsetX
 * 
 * @param windowDimmerOffsetY
 * 
 * @param msgBoxFontSize
 * @type number
 * @default 36
 * 
 * @param msgPadding
 * @type number
 * @default 8
 * 
 * @param nameBoxPadding
 * @type number
 * @default 8
 * 
 * @param nameBoxFontSize
 * @type number
 * @default 36
 * 
 * @param nameBoxFontColor
 * @type string
 * @default #ffffff
 * 
 * @param lineHeight
 * @text Line Height
 * @type number
 * @default 40
 * 
 * @param nameBoxLineHeight
 * @type number
 * @default 48
 * 
 * @param msgBoxLineHeight
 * @type number
 * @default 48
 * 
 * @param nameBoxPadding
 * @text Name Box Padding
 * @type number
 * @default 0
 * 
 * @param startUpFullScreen
 * @type boolean
 * @default true
 * 
 * @param msgFrameFlag
 * @type number
 * @default -1
 */

(() => {
    Liy = Liy || {};
    Liy.messageAlign = 8;

    Ve = Ve || {};
    Ve.params = Ve.params || {};
    Ve.MSG = {};

    const pluginName = "Ve_1_Message";
    const params = PluginManager.parameters(pluginName);

    Ve.params.lineHeight = Number(params["lineHeight"]) || 48;
    Ve.params.msgBoxLineHeight = Number(params["msgBoxLineHeigh"]) || 48;
    Ve.params.nameBoxLineHeight = Number(params["nameBoxLineHeight"]) || 48;
    Ve.params.useCustomWindow = eval(params["useCustomWindow"]) || true;
    Ve.params.windowBgAnimeOffsetX = Number(params["windowBgAnimeOffsetX"]) || 0;
    Ve.params.windowBgAnimeOffsetY = Number(params["windowBgAnimeOffsetY"]) || 200;
    Ve.params.windowDimmerOffsetX = params["windowDimmerOffsetX"] || "0";
    Ve.params.windowDimmerOffsetY = params["windowDimmerOffsetY"] || "this._messageWindow.height / 2";
    Ve.params.msgPadding = Number(params["msgPadding"]) || 8;
    Ve.params.msgBoxFontSize = Number(params["msgBoxFontSize"]);
    Ve.params.nameBoxPadding = Number(params["nameBoxPadding"]) || 8;
    Ve.params.nameBoxFontSize = Number(params["nameBoxFontSize"]) || 32;
    Ve.params.nameBoxPadding = Number(params["nameBoxPadding"]) || 0;
    Ve.params.nameBoxFontColor = params["nameBoxFontColor"] || '#ffffff';
    Ve.params.startUpFullScreen = params["startUpFullScreen"] === 'true';
    Ve.params.msgFrameFlag = Number(params["msgFrameFlag"]) || -1;

    Scene_Base.prototype.createMessageBackground = function () {
        this._msgBg = new Sprite_MsgBg("msgbox");
        this._dimmerUpper = new Sprite_MsgBgDimmer("dimmerUpper", -1);
        this._dimmerLower = new Sprite_MsgBgDimmer("dimmerLower", 1);
        this.addChild(this._msgBg);
        this.addChild(this._dimmerUpper);
        this.addChild(this._dimmerLower);
    }

    Scene_Map.prototype.createDisplayObjects = function () {
        this.createSpriteset();
        this.createMessageBackground();
        this.createWindowLayer();
        this.createAllWindows();
        this.createButtons();
    };

    Scene_Message.prototype.createMessageWindow = function () {
        const rect = this.messageWindowRect();
        this._messageWindow = new Window_Message(rect);
        if (this._msgBg) this._msgBg.setWindow(this._messageWindow);
        if(this._dimmerUpper) this._dimmerUpper.setWindow(this._messageWindow);
        if(this._dimmerLower) this._dimmerLower.setWindow(this._messageWindow);
        this._messageWindow.setMsgBg(this._msgBg);
        this.addWindow(this._messageWindow);
    };

    Window_Base.prototype.lineHeight = function () {
        return Ve.params.lineHeight;
    };

    Window_Message.prototype.lineHeight = function() {
        return $gameMessage.background() === 0 ? Ve.params.msgBoxLineHeight : 64;
    }

    Window_Message.prototype.setMsgBg = function(msgBg) {
        this._msgBg = msgBg;
    }

    Window_Message.prototype.resetFontSettings = function() {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = Ve.params.msgBoxFontSize;
        this.resetTextColor();
    };

    Window_Message.prototype.setBackgroundType = function(type) {
        this.updatePadding();
        this._useMsgBg = false;
        this._useMsgDimmer = false;

        const msgFrameFlag = Ve.params.msgFrameFlag;
        const flagValue = $gameVariables._data[msgFrameFlag] || 0;
        if(Ve.params.useCustomWindow) {
            if(flagValue === 0) {
                this._useMsgBg = true;
                this._useMsgDimmer = false;
            } else if(flagValue === 1) {
                this._useMsgBg = false;
                this._useMsgDimmer = true;
            } else {
                this._useMsgBg = false;
                this._useMsgDimmer = false;
            }
        }

        if (this._useMsgBg) {
            if(Ve.params.useCustomWindow) {
                this.opacity = 0;
            } else {
                this.opacity = 255;
            }
        } else {
            this.opacity = 0;
        }

        if (this._useMsgDimmer) {
            this.showBackgroundDimmer();
            // if($gameMessage.positionType() === 1) this._useMsgDimmer = true;
        } else {
            this.hideBackgroundDimmer();
        }
    };

    Window_Message.prototype.showBackgroundDimmer = function() {
        if (!this._dimmerSprite) {
            this.createDimmerSprite();
        }
        // const bitmap = this._dimmerSprite.bitmap;
        this.refreshDimmerBitmap();
        this._dimmerSprite.visible = true;
        this.updateBackgroundDimmer();
    };

    Window_Message.prototype.updateOpen = function() {
        if (this._opening) {
            this.openness += (255 - this.openness) * 0.2;
            if(this.openness > 253) this.openness = 255;
            if (this.isOpen()) {
                this._opening = false;
            }
        }
    }

    Window_Message.prototype.updateClose = function() {
        if (this._closing) {
            this.openness -= this.openness * 0.2;
            if(this.openness < 2) this.openness = 0;
            if (this.isClosed()) {
                this._closing = false;
            }
        }
    };

    Window_Message.prototype.fittingHeight = function(numLines) {
        return numLines * this.itemHeight() + this.padding * 2;
    };

    Window_Message.prototype.updatePadding = function() {
        this.padding = $gameMessage.background() === 0 ? Ve.params.msgPadding : 24;
    };

    const _Scene_Message_prototype_createChoiceListWindow = Scene_Message.prototype.createChoiceListWindow;
    Scene_Message.prototype.createChoiceListWindow = function() {
        _Scene_Message_prototype_createChoiceListWindow.call(this);
        
    }

    //------------------------------------------------------

    Window_NameBox.prototype.fittingHeight = function(numLines) {
        return numLines * this.itemHeight() + Ve.params.nameBoxPadding * 2;
    };

    Window_NameBox.prototype.updatePadding = function() {
        this.padding = Ve.params.nameBoxPadding;
    };

    Window_NameBox.prototype.updateBackground = function () {
        this.setBackgroundType(2);
    };

    Window_NameBox.prototype.lineHeight = function() {
        return Ve.params.nameBoxLineHeight;
    };

    Window_NameBox.prototype.updatePlacement = function() {
        this.width = this.windowWidth();
        this.height = this.windowHeight();
        const messageWindow = this._messageWindow;
        // if ($gameMessage.isRTL()) {
        //     this.x = messageWindow.x + messageWindow.width - this.width;
        // } else {
        //     this.x = messageWindow.x;
        // }
        this.x = messageWindow.x + (messageWindow.width - this.width) / 2;
        if (messageWindow.y > 0) {
            this.y = messageWindow.y - this.height;
        } else {
            this.y = messageWindow.y + messageWindow.height;
        }
    };

    Window_NameBox.prototype.resetFontSettings = function() {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = Ve.params.nameBoxFontSize;
        this.resetTextColor();
    };

    Window_NameBox.prototype.windowWidth = function () {
        if (this._name) {
            const textWidth = this.textSizeEx(this._name).width;
            const padding = this.padding + this.itemPadding();
            const width = Math.ceil(textWidth) + padding * 2 + Ve.params.nameBoxPadding;
            return Math.min(width, Graphics.boxWidth);
        } else {
            return 0;
        }
    };

    Window_NameBox.prototype.resetTextColor = function() {
        this.changeTextColor(Ve.params.nameBoxFontColor);
        this.changeOutlineColor(ColorManager.outlineColor());
    }

    Window_NameBox.prototype.baseTextRect = function () {
        const rect = new Rectangle(this.windowWidth() / 2 - this.textSizeEx(this._name).width / 2 - 16, 0, this.innerWidth, this.innerHeight);
        rect.pad(-this.itemPadding(), 0);
        return rect;
    };

    Window_Message.prototype.moveNamebox = function (position) {
        if (position === 1) {
            this._nameBoxWindow.x = this.x;
        } else {
            this._nameBoxWindow.x = this.x + this.width - this._nameBoxWindow.width;
        }
    }

    Window_Message.prototype.messagePositionReset = function () {
        this._messagePositionReset = false;
        this._autoPositionTarget = undefined;
        $gameSystem.initMessageCore();
        this.updateAutoSizePosition();
        this.close();
    };

    function Sprite_MsgBg() {
        this.initialize.apply(this, arguments);
    }

    Sprite_MsgBg.prototype = Object.create(Sprite.prototype);
    Sprite_MsgBg.prototype.constructor = Sprite_MsgBg;

    Sprite_MsgBg.prototype.initialize = function (bitmap) {
        Sprite.prototype.initialize.call(this);
        this.bitmap = ImageManager.loadBitmap("img/ui/", bitmap);
        this._messageWindow = null;
        this._backgroundType = 0;
        this.opacity = 0;
        this.z = -100;
        this.update();
    }

    Sprite_MsgBg.prototype.loadBitmap = function (filename) {
        this.bitmap = ImageManager.loadBitmap("img/ui/", filename);
    }

    Sprite_MsgBg.prototype.setWindow = function (window) {
        this._messageWindow = window;
    }

    Sprite_MsgBg.prototype.setBackgroundType = function(type) {
        this._backgroundType = type;
    }

    Sprite_MsgBg.prototype.update = function () {
        Sprite.prototype.update.call(this);
        this.updateAnimation();
    }

    Sprite_MsgBg.prototype.updateAnimation = function () {
        if (this._messageWindow) {
            const openness = this._messageWindow.openness;
            const offsetY = eval(Ve.params.windowBgAnimeOffsetY);
            const offserX = eval(Ve.params.windowBgAnimeOffsetX);
            if(this._messageWindow._useMsgBg) {
                this.opacity = openness;
                this.x = offserX * (1 - openness / 255);
                this.y = offsetY * (1 - openness / 255);
            }
        }
    }

    function Sprite_MsgBgDimmer() {
        this.initialize.apply(this, arguments);
    }

    Sprite_MsgBgDimmer.prototype = Object.create(Sprite_MsgBg.prototype);
    Sprite_MsgBgDimmer.prototype.constructor = Sprite_MsgBgDimmer;

    Sprite_MsgBgDimmer.prototype.initialize = function(bitmap, pos = 1) {
        Sprite_MsgBg.prototype.initialize.call(this, bitmap);
        this._dimmerPos = pos;
    }

    Sprite_MsgBgDimmer.prototype.updateAnimation = function () {
        if (this._messageWindow) {
            if(this._messageWindow._useMsgDimmer) {
                const offsetY = (this._messageWindow.height + 72) / 2;
                const openness = this._messageWindow.openness;
                this.opacity = openness;
                this.y = offsetY * (openness / 255) * this._dimmerPos - 64;
            } else {
                this.opacity = 0;
            }
        }
    }

    function Sprite_ChoiceBg() {
        this.initialize.apply(this, arguments);
    }

    Sprite_ChoiceBg.prototype = Object.create(Sprite_MsgBgDimmer.prototype);
    Sprite_ChoiceBg.prototype.constructor = Sprite_ChoiceBg;

    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        _Scene_Boot_start.apply(this, arguments)
        if (Ve.params.startUpFullScreen && !DataManager.isEventTest()) {
            Graphics._requestFullScreen();
        }
    };
})();