/*:
 * @target MZ
 * @author Moiyri
 * 
 * @param bg
 * @type file
 * @dir /img/menus
 */

ImageManager.loadMenus = function (filename) {
    return this.loadBitmap('img/menus/', filename);
};

// 在文件顶部添加预加载变量
let _preloadedSprites = {
    buttons: {},
    background: null
};

(() => {
    Ve = Ve || {};
    Ve.Settings = {};

    const pluginName = "Menu";
    const params = PluginManager.parameters(pluginName);

    Scene_Load.prototype.listWindowRect = function () {
        const wx = 200;
        const wy = this.mainAreaTop() + this._helpWindow.height + 100;
        const ww = Graphics.boxWidth - 400;
        const wh = this.mainAreaHeight() - 220 - this._helpWindow.height;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Load.prototype.helpWindowRect = function () {
        const wx = 200;
        const wy = this.mainAreaTop() + 100;
        const ww = Graphics.boxWidth - 400;
        const wh = this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Save.prototype.listWindowRect = function () {
        const wx = 200;
        const wy = this.mainAreaTop() + this._helpWindow.height + 110;
        const ww = Graphics.boxWidth - 400;
        const wh = this.mainAreaHeight() - 220 - this._helpWindow.height;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Save.prototype.helpWindowRect = function () {
        const wx = 200;
        const wy = this.mainAreaTop() + 100;
        const ww = Graphics.boxWidth - 400;
        const wh = this.calcWindowHeight(1, false);
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Gameover.prototype.start = function () {
        Scene_Base.prototype.start.call(this);
        this.adjustBackground();
        // this.startFadeIn(this.slowFadeSpeed(), false);
    };

    // =========================================================================
    class Scene_Menu_Ve extends Scene_MenuBase {
        initialize() {
            super.initialize();
            this._sceneOffsetX = 100;
            this._bgOffsetX = 650;
            this._itemListWindowOffsetX = Graphics.boxWidth - 100;
            this._loadWindowOffetx = Graphics.boxWidth - 500;
            this._buttonOffsetX = 300;
            this._originX = this._sceneOffsetX;
            this._itemListWindowTargetX = -700;
            this._statusWindowOffsetX = 20;
        }

        create() {
            super.create();
            this.createBackgroundSprite();
            this.createCommandWindow();
            this.createItemListWindow();
            this.createMenuButtons();
            this.createSaveWindow(); // 添加保存窗口创建
            this.createStatusWindow()
        }

        createStatusWindow() {
            const rect = this.statusWindowRect();
            this._statusWindow = new Window_Status_Ve(rect);
            this.addWindow(this._statusWindow);
        }

        statusWindowRect() {
            const ww = 640; // 窗口宽度
            const wh = 120; // 窗口高度
            const wx = this._statusWindowOffsetX + this._originX;  // 左侧留20px边距
            const wy = Graphics.boxHeight - wh - 20; // 底部留20px边距
            return new Rectangle(wx, wy, ww, wh);
        }

        saveWindowRect() {
            const margin = 100; // 边距
            const ww = 600; // 窗口宽度
            const wh = 400; // 窗口高度
            const wx = this._loadWindowOffetx; // 初始在屏幕外
            const wy = (Graphics.boxHeight - wh) / 2; // 垂直居中
            return new Rectangle(wx, wy, ww, wh);
        }

        createSaveWindow() {
            const rect = this.saveWindowRect();
            this._saveWindow = new Window_SaveFile_Ve(rect);
            this._saveWindow.setHandler("ok", this.onSaveOk.bind(this));
            this._saveWindow.setHandler("cancel", this.onSaveCancel.bind(this));
            this._saveWindow.hide(); // 初始隐藏
            this.addWindow(this._saveWindow);
        }

        onSaveOk() {
            // 处理保存确认
        }

        onSaveCancel() {
            // 处理保存取消
            this._saveWindow.hide();
            this._commandWindow.activate();
        }

        itemListWindowRect() {
            const ww = 520; // 窗口宽度
            const wh = 540; // 窗口高度与屏幕相同
            const wx = this._itemListWindowOffsetX; // 画面外100px
            const wy = Graphics.boxHeight / 2 - wh / 2; // 窗口垂直居中;
            return new Rectangle(wx, wy, ww, wh);
        }

        createItemListWindow() {
            const rect = this.itemListWindowRect();
            this._itemListWindow = new Window_ItemList_Ve(rect);
            this._itemListWindow.setHandler("ok", this.onItemOk.bind(this));
            this._itemListWindow.setHandler("cancel", this.onItemCancel.bind(this));
            this._itemListWindow.hide(); // 隐藏窗口，直到需要显示  
            this.addWindow(this._itemListWindow);
        }

        onItemOk() {
            // 处理物品选择确定
            $gameParty.setLastItem(this._itemListWindow.item());
            this.determineItem();
        }

        determineItem() {
            for (const effect of this._itemListWindow.item().effects) {
                if (effect.code === Game_Action.EFFECT_COMMON_EVENT) {
                    $gameTemp.reserveCommonEvent(effect.dataId);
                }
            }
            if ($gameTemp.isCommonEventReserved()) {
                SceneManager.goto(Scene_Map);
            } else {
                this._itemListWindow.refresh();
                this._itemListWindow.activate();
            }
        }

        onItemCancel() {
            // 处理物品选择取消
            this._sceneOffsetX = this._originX;
            this._itemListWindow.hide();
            this._commandWindow.activate();
        }

        start() {
            super.start();
            this._bgSlideIn = true;
            this._buttonSlideIn = true;
            this._buttonSlideCount = 0;
        }

        update() {
            super.update();
            this.updateBgSlide();
            this.updateButtonsSlide();
            this.updateItemWindow();
            this.updateOffsetX();
            this.updatestatusWindow();
        }

        updatestatusWindow() {
            this._statusWindow.x = this._statusWindowOffsetX + this._sceneOffsetX;
        }

        updateOffsetX() {

        }

        updateItemWindow() {
            this._itemListWindow.x = this._itemListWindowOffsetX + this._sceneOffsetX;
        }

        updateMenuIndex() {
            this._menuButtons.forEach((button, index) => {
                button.setIndex(this._commandWindow.index());
            });
        }

        createBackgroundSprite() {
            this._bgSprite = new Sprite();
            this._bgSprite.bitmap = ImageManager.loadBitmap('img/menus/', 'menu_bg');
            this._bgSprite.x = Graphics.boxWidth + this._sceneOffsetX;
            this._bgSprite.y = 0;
            this.addChildAt(this._bgSprite, 3);
            this._bgSlideCount = 0;
        }

        createMenuButtons() {
            this._menuButtons = [];
            const buttonNames = ['item', 'paper', 'load', 'option'];
            const lang = "";
            const buttonY = [100, 200, 300, 400];
            this._buttonTargetX = 150 + this._sceneOffsetX;
            this._buttonStartX = -200 + this._sceneOffsetX;

            buttonNames.forEach((name, index) => {
                const bitmap = ImageManager.loadBitmap('img/menus/', name + '_btn' + lang);
                const button = new Sprite_MenuButton(bitmap);
                button.x = this._buttonStartX;
                button.y = buttonY[index];
                button.anchor.set(0.5);
                button.setIndex(index);
                button.setCommandWindow(this._commandWindow);
                button.setClickHandler(this.onButtonClick.bind(this, name));
                this._menuButtons.push(button);
                this.addChild(button);
            });
        }

        onButtonClick(command) {
            switch (command) {
                case 'item': this.commandItem(); break;
                case 'paper': this.commandPaper(); break;
                case 'load': this.commandLoad(); break;
                case 'option': this.commandOptions(); break;
            }
        }

        updateButtonsSlide() {
            this._buttonTargetX = 150 + this._sceneOffsetX;

            if (this._buttonSlideIn || this._buttonSlideOut) {
                this._buttonSlideCount++;
                const isSlideIn = this._buttonSlideIn;
                const duration = isSlideIn ? 25 : 20;
                const baseDelay = isSlideIn ? 5 : 3;

                this._menuButtons.forEach((button, index) => {
                    const delayedCount = this._buttonSlideCount - (index * baseDelay);
                    if (delayedCount > 0) {
                        const progress = Math.min(1, delayedCount / duration);
                        const easeProgress = this.easeOutQuad(progress);
                        button.x = isSlideIn
                            ? this._buttonStartX + ((this._buttonTargetX - this._buttonStartX) * easeProgress)
                            : this._buttonTargetX - ((this._buttonTargetX + 200) * easeProgress);
                    }
                });

                if (this._buttonSlideCount >= duration + (this._menuButtons.length - 1) * baseDelay) {
                    isSlideIn ? (this._buttonSlideIn = false) : (this._buttonSlideOut = false);
                }
            } else {
                this._menuButtons.forEach((button, index) => {
                    button.x = this._buttonTargetX;
                });
            }
        }

        updateBgSlide() {
            if (this._bgSlideIn) {
                this._bgSlideCount++;
                const duration = 20;
                const progress = Math.min(1, this._bgSlideCount / duration);
                const easeProgress = this.easeOutQuad(progress);
                this._bgSprite.x = Graphics.boxWidth - (Graphics.boxWidth * easeProgress) + this._bgOffsetX + this._sceneOffsetX;

                if (progress >= 1) {
                    this._bgSlideIn = false;
                }
            } else if (this._bgSlideOut) {
                this._bgSlideCount++;
                const duration = 20;
                const progress = Math.min(1, this._bgSlideCount / duration);
                const easeProgress = this.easeOutQuad(progress);
                this._bgSprite.x = easeProgress * Graphics.boxWidth + this._bgOffsetX + this._sceneOffsetX;

                if (progress >= 1) {
                    SceneManager.pop();
                }
            } else {
                this._bgSprite.x = this._bgOffsetX + this._sceneOffsetX;
            }
        }

        onItemCancel() {
            // 处理物品选择取消
            this._isMovingToItem = false; // 切换为返回状态
            this._moveStartX = this._sceneOffsetX; // 记录起始位置
            this._moveFrameCount = 0; // 重置帧计数器
            this._itemListWindow.deactivate();
        }

        updateOffsetX() {
            if (this._isMovingToItem !== undefined) {
                this._moveFrameCount++;
                const duration = 20; // 动画持续时间
                const progress = Math.min(1, this._moveFrameCount / duration);
                const easeProgress = this.easeOutQuad(progress);

                if (this._isMovingToItem) {
                    // 向目标位置缓动
                    this._sceneOffsetX = this._moveStartX +
                        (this._itemListWindowTargetX - this._moveStartX) * easeProgress;

                    if (progress >= 1) {
                        this._isMovingToItem = undefined; // 动画完成
                    }
                } else {
                    // 向原始位置缓动
                    this._sceneOffsetX = this._moveStartX +
                        (this._originX - this._moveStartX) * easeProgress;

                    if (progress >= 1) {
                        this._isMovingToItem = undefined; // 动画完成
                        this._itemListWindow.hide();
                        this._commandWindow.activate();
                    }
                }
            }
        }


        commandWindowRect() {
            const margin = 20;
            const ww = 300;
            const wh = Graphics.boxHeight * 2 / 3;
            const wx = Graphics.boxWidth + this._sceneOffsetX;
            const wy = margin;
            return new Rectangle(wx, wy, ww, wh);
        }

        easeOutQuad(t) {
            return 1 - Math.pow(1 - t, 3);
        }

        popScene() {
            this._bgSlideOut = true;
            this._buttonSlideOut = true;
            this._buttonSlideCount = 0;
            this._bgSlideCount = 0;
        }

        createCommandWindow() {
            const rect = this.commandWindowRect();
            const commandWindow = new Window_MenuCommand_Ve(rect);
            commandWindow.setHandler("item", this.commandItem.bind(this));
            commandWindow.setHandler("paper", this.commandPaper.bind(this));
            commandWindow.setHandler("load", this.commandLoad.bind(this));
            commandWindow.setHandler("option", this.commandOptions.bind(this));
            commandWindow.setHandler("cancel", this.popScene.bind(this));
            this.addWindow(commandWindow);
            this._commandWindow = commandWindow;
        }

        commandItem() {
            // 处理Item命令
            // this._commadnWindow.deactivate();
            this._itemListWindow.show();
            this._itemListWindow.refresh();
            this._itemListWindow.activate();
            this._itemListWindow.select(0);
            if (this._commandWindow) {
                this._commandWindow.deactivate();
            }
            this._isMovingToItem = true; // 添加状态标志
            this._moveStartX = this._sceneOffsetX; // 记录起始位置
            this._moveFrameCount = 0; // 重置帧计数器
        }

        commandPaper() {
            // 处理Paper命令
            SceneManager.push(Scene_BookMenu);
        }

        commandLoad() {
            // 处理Load命令 
            SceneManager.push(Scene_Load);
            // this._saveWindow.show();
            // this._saveWindow.activate();
        }

        commandOptions() {
            // 处理Option命令
            SceneManager.push(Scene_Options);
        }

        commandSave() {
            // 处理Save命令
            this._saveWindow.show();
            this._saveWindow.activate();
        }
    }

    // 创建新的菜单命令窗口类
    class Window_MenuCommand_Ve extends Window_Command {
        initialize(rect) {
            super.initialize(rect);
            this._contentsBackSprite.alpha = 0;
            this._canRepeat = false;
            this.visible = true;
            this.setBackgroundType(1);
        }

        maxCols() {
            return 1; // 只有一列
        }

        makeCommandList() {
            this.addCommand('Item', 'item', true);
            this.addCommand('Paper', 'paper', true);
            this.addCommand('Load', 'load', true);
            this.addCommand('Option', 'option', true);
        }
    }

    class Sprite_MenuButton extends Sprite_Clickable {
        constructor(bitmap) {
            super();
            this.initialize(bitmap);
            this._targetScale = 1.0; // 添加目标缩放值
            this._currentScale = 1.0; // 添加当前缩放值
            this._scaleSpeed = 0.2; // 缩放动画速度
        }

        initialize(bitmap) {
            super.initialize();
            this.bitmap = bitmap;
            this._commadnWindow = null;
            this._selectScale = 1.2;
        }

        update() {
            super.update();
            this.updateSelect();
            this.updateScale(); // 添加缩放更新
        }

        updateScale() {
            // 缓动动画更新
            if (Math.abs(this._currentScale - this._targetScale) > 0.01) {
                this._currentScale += (this._targetScale - this._currentScale) * this._scaleSpeed;
                this.scale.x = this._currentScale;
                this.scale.y = this._currentScale;
            } else {
                this.scale.x = this._targetScale;
                this.scale.y = this._targetScale;
            }
        }

        updateSelect() {
            const selectIndex = this._commadnWindow.index();
            const isSelected = this._index === selectIndex;

            if (this._hovered || isSelected) {
                if (!isSelected) {
                    SoundManager.playCursor();
                    this._commadnWindow.select(this._index);
                }
                this._targetScale = this._selectScale; // 更新目标缩放值
                this.alpha = 1;
            } else {
                this._targetScale = 1.0; // 更新目标缩放值
                this.alpha = 0.5;
            }
        }

        setCommandWindow(commandWindow) {
            this._commadnWindow = commandWindow;
        }

        setIndex(index) {
            this._index = index;
        }

        setClickHandler(handler) {
            this._clickHandler = handler;
        }

        onClick() {
            if (this._clickHandler) {
                SoundManager.playOk(); // 添加OK音效
                this._clickHandler();
            }
        }
    }

    // 创建新的物品列表窗口类
    class Window_ItemList_Ve extends Window_ItemList {
        initialize(rect) {
            super.initialize(rect);
            this._category = "none";
            this._data = [];

            this.setBackgroundType(1);

            // 创建底部装饰框架
            this._frameSprite = new Sprite();
            this._frameSprite.bitmap = ImageManager.loadBitmap('img/ui/', 'event_item_frame');
            this._frameSprite.anchor.set(0.5, 0.5); // 设置锚点为中心

            // 将精灵添加到窗口
            this.addChild(this._frameSprite);

            // 更新框架位置
            this._frameSprite.x = this.width / 2;
            this._frameSprite.y = this.height / 2;
        }

        maxCols() {
            return 1;
        }

        includes(item) {
            return !!item;
        }

        drawItemName(item, x, y, width) {
            if (item) {
                const textMargin = 4;
                const itemWidth = Math.max(0, width - textMargin);
                
                // 如果物品是关键物品，设置为红色
                if (item.meta && item.meta.keyItem) {
                    this.changeTextColor(ColorManager.textColor(31)); // 10是红色
                } else {
                    this.resetTextColor();
                }
                
                this.drawText(item.name, x + textMargin, y, itemWidth, "left");
            }
        }

        drawItemNumber(item, x, y, width) {
            // 空实现，不绘制数量
        }

        update() {
            super.update();
        }

        hide() {
            super.hide();
            this._frameSprite.visible = false;
        }

        show() {
            super.show();
            this._frameSprite.visible = true;
        }
    }

    Scene_Map.prototype.callMenu = function () {
        SoundManager.playOk();
        SceneManager.push(Scene_Menu_Ve);  // 修改为使用Scene_Menu_Ve
        Window_MenuCommand.initCommandPosition();
        $gameTemp.clearDestination();
        this._mapNameWindow.hide();
        this._waitCount = 2;
    };

    // 继承原本的存档列表窗口
    class Window_SaveFile_Ve extends Window_SavefileList {
        initialize(rect) {
            super.initialize(rect);
            this.setBackgroundType(1);
            this.refresh();
        }

        drawTitle(savefileId, x, y) {
            // 重写标题绘制方法
            this.drawText(TextManager.file + " " + savefileId, x, y, 180);
        }

        drawContents(info, rect) {
            // 重写存档内容绘制方法
            const bottom = rect.y + rect.height;
            if (info) {
                this.drawPartyCharacters(info, rect.x + 220, bottom - 4);
                this.drawPlaytime(info, rect.x, bottom - this.lineHeight(), rect.width);
            }
        }

        drawPartyCharacters(info, x, y) {
            // 重写队伍角色绘制方法
            if (info.characters) {
                let characterX = x;
                for (const data of info.characters) {
                    this.drawCharacter(data[0], data[1], characterX, y);
                    characterX += 48;
                }
            }
        }

        drawPlaytime(info, x, y, width) {
            // 重写游戏时间绘制方法
            if (info.playtime) {
                this.drawText(info.playtime, x, y, width, "right");
            }
        }
    }

    class Window_Status_Ve extends Window_Base {
        initialize(rect) {
            super.initialize(rect);
            this.refresh();
            this.setBackgroundType(1);
            this._playTime = $gameSystem.playtimeText();
            this._step = $gameParty.steps();
            this._gold = $gameParty.gold();
        }

        update() {
            super.update();
            this._playTime = $gameSystem.playtimeText();
            this._step = $gameParty.steps();
            this._gold = $gameParty.gold();
            this.refresh();
        }

        refresh() {
            this.contents.clear();
            this.drawStatusInfo();
        }

        drawStatusInfo() {
            const y = 0;
            const spacing = 40; // 信息之间的间距

            // 绘制金币
            this.changeTextColor(ColorManager.systemColor());
            this.drawText(TextManager.currencyUnit, 0, y, 60);
            this.resetTextColor();
            this.drawText(this._gold, 70, y, 80, 'right');

            // 绘制步数
            this.changeTextColor(ColorManager.systemColor());
            this.drawText("${steps}:", 0 + spacing + 150, y, 60);
            this.resetTextColor();
            this.drawText(this._step, 220 + spacing, y, 80, 'right');

            // 绘制游戏时间
            this.changeTextColor(ColorManager.systemColor());
            this.drawText("${playTime}:", 300 + spacing * 2, y, 60);
            this.resetTextColor();
            this.drawText(this._playTime, 370 + spacing * 2, y, 120, 'right');
        }
    }

})();


