/*:
 * @target MZ
 * @author KuiMoiyri
 * 
 * @param localizationNames
 * @type string[]
 * @desc A list of localization names to be used in the game
 * @default []
 */

(() => {
    Ve = Ve || {};
    const pluginName = "Ve_1_Localizations";
    const params = PluginManager.parameters(pluginName);
    Ve.localizationNames = JSON.parse(params["localizationNames"] || "[]");

    DataManager.loadLocalization = function () {
        if (!TextManager.isVisuMzLocalizationEnabled())
            return;
        // const _0x33c6ab = VisuMZ.MessageCore.Settings.Localization;
        for (const name of Ve.localizationNames) {
            const _0x107cea = name || '';
            if (!_0x107cea)
                return;
            const _0x1a6764 = '$dataLocalization';
            const _0x544996 = new XMLHttpRequest();
            const _0x302c7d = 'data/' + _0x107cea;
            window[_0x1a6764] = null;
            _0x544996.open('GET', _0x302c7d);
            _0x544996.overrideMimeType('application/csv');
            _0x544996.onload = () => this.onLocalizationXhrLoad(_0x544996, _0x1a6764);
            _0x544996.onerror = () => this.onLocalizationXhrError();
            _0x544996.send();
        }
    };

    DataManager.onLocalizationXhrLoad = function (_0x408454, _0xec0be2) {
        if (_0x408454.status >= 400)
            return;
        const _0x1c2e0e = _0x408454.responseText;
        const parsedData = VisuMZ.MessageCore.ParseLocalizationCsv(_0x1c2e0e);
        window[_0xec0be2] = window[_0xec0be2] || {};
        for (let key in parsedData) {
            window[_0xec0be2][key] = parsedData[key];
        }
    };
})();