/*:
 * @target MZ
 * @author Moiyri
 * @plugindesc 物品选择窗口插件
 * 
 * @command OpenItemSelect
 * @text 打开物品选择窗口
 * @desc 打开一个物品选择窗口，选择的物品ID会存入指定变量中
 * 
 * @arg variableId
 * @text 变量ID
 * @desc 存储选择结果的变量ID
 * @type number
 * @default 1
 * 
 * @arg useEffects
 * @text 使用效果
 * @desc 是否显示物品效果
 * @type boolean
 * @default false
 */

(() => {
    const pluginName = 'Ve_1_Item';
    // 修改Window_EventItem的初始化方法
    const _Window_EventItem_initialize = Window_EventItem.prototype.initialize;
    Window_EventItem.prototype.initialize = function(rect) {
        rect.width = 480;
        rect.x = Graphics.boxWidth;
        rect.height = 480; // 修改高度为480
        rect.y = (Graphics.boxHeight - rect.height) / 2;
        
        _Window_EventItem_initialize.call(this, rect);
        this.x = Graphics.boxWidth;
        this._centerY = (Graphics.boxHeight - rect.height) / 2;
        
        // 修改背景精灵加载方式
        this._frameSprite = new Sprite();
        this._frameSprite.bitmap = ImageManager.loadBitmap('img/ui/', 'event_item_frame');
        this.addChildAt(this._frameSprite, 1); // 显示在最上层
        this._frameSprite.anchor.x = 0.5;
        this._frameSprite.anchor.y = 0.5;
        this._frameSprite.x = this.width / 2;
        this._frameSprite.y = -this._frameSprite.height / 2; // 调整到窗口上方
        this._frameSprite.visible = true; 
    };

    // 添加缓动函数
    // 修改缓动函数为更平滑的easeOutQuint
    Window_EventItem.prototype.easeOutQuad = function(t) {
        return 1 - Math.pow(1 - t, 3); // 使用三次方缓动
    };

    // 修改动画持续时间
    const _Window_EventItem_update = Window_EventItem.prototype.update;
    Window_EventItem.prototype.update = function() {
        _Window_EventItem_update.call(this);
        if (this._isSliding) {
            this.y = this._centerY;
            this._frameSprite.x = this.width / 2;
            this._frameSprite.y = this.height / 2;
            
            // 增加动画持续时间并使用更平滑的缓动
            const duration = 20; // 从10帧增加到20帧
            const progress = Math.min(1, this._slideFrameCount / duration);
            const easeProgress = this.easeOutQuad(progress);
            
            this.x = Graphics.boxWidth + 
                    (this._slideTarget - Graphics.boxWidth) * easeProgress;
            
            this._slideFrameCount++;
            
            if (progress >= 1) {
                this._isSliding = false;
                if (this._closing) {
                    _Window_EventItem_close.call(this);
                    this._closing = false;
                }
            }
            
            this._openness = this.x === Graphics.boxWidth ? 0 : 255;
        }
    };

    // 修改打开方法
    const _Window_EventItem_open = Window_EventItem.prototype.open;
    Window_EventItem.prototype.open = function() {
        _Window_EventItem_open.call(this);
        this.setBackgroundType(2);
        this._openness = 0;
        this.x = Graphics.boxWidth;
        this._slideTarget = Graphics.boxWidth - this.width - 140; // 距离右侧150像素
        this._isSliding = true;
        this._slideFrameCount = 0;
    };

    // 重写关闭窗口的动画
    const _Window_EventItem_close = Window_EventItem.prototype.close;
    Window_EventItem.prototype.close = function() {
        this._slideTarget = Graphics.boxWidth;
        this._isSliding = true;
        this._closing = true;
    };

    // 添加maxCols方法限制每行2个物品
    Window_EventItem.prototype.maxCols = function() {
        return 2; // 每行显示2个物品
    };

    // 修改itemHeight方法调整物品高度
    Window_EventItem.prototype.itemHeight = function() {
        return 72; // 根据新高度调整物品高度
    };

    // 重写drawItemNumber方法为空实现
    Window_EventItem.prototype.drawItemNumber = function(item, x, y, width) {
        // 空实现，不绘制物品数量
    };

    // 修改drawItemName方法只绘制名称
    Window_EventItem.prototype.drawItemName = function(item, x, y, width) {
        if (item) {
            const textMargin = 4;
            const itemWidth = Math.max(0, width - textMargin);
            this.resetTextColor();
            this.drawText(item.name, x + textMargin, y, itemWidth, "left");
        }
    };
})();