/*:
 * @target MZ
 * @author KuiMoiyri
 * 
 * @command setFocus
 * 
 * @arg target
 */

(() => {
    ScSWinterZoom = ScSWinterZoom || {};

    Game_Map.prototype.setDisplayPos = function (x, y) {
        if (this.isLoopHorizontal()) {
            this._displayX = x.mod(this.width());
            this._parallaxX = x;
        } else if (ScSWinterZoom.FreeCamera) {
            this._displayX = x;
            this._parallaxX = x;
        } else {
            const endX = this.width() - this.screenTileX() + this._extraScreenTileX * 2;
            this._displayX = endX < 0 ? endX / 2 - this._extraScreenTileX : x.clamp(this._extraScreenTileX * -1, endX - this._extraScreenTileX);
            this._parallaxX = this._displayX;
        }
        if (this.isLoopVertical()) {
            this._displayY = y.mod(this.height());
            this._parallaxY = y;
        } else if (ScSWinterZoom.FreeCamera) {
            this._displayY = y;
            this._parallaxY = y;
        } else {
            const endY = this.height() - this.screenTileY() + this._extraScreenTileY * 2;
            this._displayY = endY < 0 ? endY / 2 - this._extraScreenTileY : y.clamp(this._extraScreenTileY * -1, endY - this._extraScreenTileY);
            this._parallaxY = this._displayY;
        }
    };

    Game_Player.prototype.updateScroll = function (lastScrolledX, lastScrolledY) {
    }

    Game_Map.prototype.updateScroll = function () {
        // if (this.isScrolling()) {
        //     const lastX = this._displayX;
        //     const lastY = this._displayY;
        //     this.doScroll(this._scrollDirection, this.scrollDistance());
        //     if (this._displayX === lastX && this._displayY === lastY) {
        //         this._scrollRest = 0;
        //     } else {
        //         this._scrollRest -= this.scrollDistance();
        //     }
        // }
        const screenWidth = Graphics.width;
        const screenHeight = Graphics.height;
        const tileWidth = $gameMap.tileWidth();
        const tileHeight = $gameMap.tileHeight();

        const playerX = $gamePlayer.x;
        const playerY = $gamePlayer.y;

        const newDisplayX = playerX - Math.floor(screenWidth / tileWidth / 2);
        const newDisplayY = playerY - Math.floor(screenHeight / tileHeight / 2);

        // console.log(newDisplayX, newDisplayY)

        // 更新地图的显示位置
        let sx = (newDisplayX - $gameMap._displayX) / 20;
        let sy = (newDisplayY - $gameMap._displayY) / 20;

        if (Math.abs(sx) * 15 < 0.01) {
            sx = 0;
            this._displayX = $gamePlayer.x - $gamePlayer.centerX();
            
        }

        if(Math.abs(sy) * 15 < 0.01) {
            sy = 0;
            this._displayY = $gamePlayer.y - $gamePlayer.centerY();
        }

        sx = Math.abs(sx) / 15 < 0.0001 ? newDisplayX - $gameMap._displayX : sx;
        sy = Math.abs(sy) / 15 < 0.0001 ? newDisplayY - $gameMap._displayY : sy;
        // console.log($gameMap._displayX,$gameMap._displayY);



        if (sy < 0) {
            this.scrollUp(Math.abs(sy));
        } else if (sy > 0) {
            this.scrollDown(Math.abs(sy));
        };

        if (sx < 0) {
            this.scrollLeft(Math.abs(sx));
        } else if (sx > 0) {
            this.scrollRight(Math.abs(sx));
        };
    };
})();
