/*:
 * @target MZ
 * @author KuiMoiyri
 * 
 * @param test
 * 
 * @param demoVer
 * @type boolean
 * @parent test
 * 
 * @param test_common
 * @type boolean
 * @parent test
 * 
 * @param test_el
 * @type boolean
 * @parent test
 * 
 * @param test_et
 * @type boolean
 * @parent test
 * 
 * @param text_ge
 * @type boolean
 * @parent test
 * 
 * @param test_vi
 * @type boolean
 * @parent test
 * 
 * 
 */

(() => {
    const pluginName = "Ve_0"

    const params = PluginManager.parameters(pluginName);

    Ve = {};
    Ve.params = {};
    Ve.Event = {};
    Ve.test = {};

    Ve.test.testCommon = params["test_common"] === "true";
    Ve.test.testEl = params["test_el"] === "true";
    Ve.test.testEt = params["test_et"] === "true";
    Ve.test.testGe = params["text_ge"] === "true";
    Ve.test.testVi = params["test_vi"] === "true";
    Ve.test.demoVer = params["demoVer"] === "true";

    Ve.isTriggeredC = false;

    Ve.moveBackward = function () {
        // 获取玩家当前方向（2=下, 4=左, 6=右, 8=上）
        const dir = this.direction();

        // 反方向映射表
        const reverseDir = { 2: 8, 8: 2, 4: 6, 6: 4 };

        // 尝试优先向反方向移动
        const targetDir = reverseDir[dir];
        const [x, y] = [this.x, this.y];
        let canMove = false;

        // 检查反方向是否可通行
        if (this.canPass(x, y, targetDir)) {
            this.moveBackward();
            canMove = true;
        } else {
            // 按顺时针顺序检查其他方向（右→下→左→上）
            [6, 2, 4, 8].some((newDir) => {
                const backDir = reverseDir[newDir];
                if (this.canPass(x, y, backDir)) {
                    this.setDirection(newDir);
                    this.moveBackward();
                    canMove = true;
                    return true; // 找到可行方向，停止搜索
                }
                return false;
            });
        }

        // 如果完全无法后退，可以在这里添加额外逻辑（如播放SE提示）
        // if (!canMove) {
        //     $gamePlayer.requestBalloon(2); // 显示"！"气泡提示
        // }
    }

    const WINDOW_CURSOR_OFFSET_X = 0;

    Game_Character.prototype.isFacingEvent = function (mapId, eventId) {
        // 获取指定事件
        const _mapId = $gameMap._mapId;
        const event = $gameMap.event(eventId);
        if (!event) {
            return false; // 如果事件不存在，返回false
        }

        // 获取主角和事件的位置
        const x = this.x;
        const y = this.y;
        const eventX = event.x;
        const eventY = event.y;

        // 判断主角是否紧靠事件
        const isAdjacent = (Math.abs(x - eventX) <= 1 && Math.abs(y - eventY) <= 1);
        if (!isAdjacent) {
            return false; // 如果不紧靠，返回false
        }

        // 判断主角是否面向事件
        const direction = this.direction();
        const facingDirection = {
            2: { x: 0, y: 1 },   // 下
            4: { x: -1, y: 0 },  // 左
            6: { x: 1, y: 0 },   // 右
            8: { x: 0, y: -1 }    // 上
        }[direction];

        return (eventX === x + facingDirection.x && eventY === y + facingDirection.y) && mapId === _mapId;
    };

    // 获取玩家面向的事件
    Game_Character.prototype.getFacingEvent = function () {
        const direction = this.direction();
        const x = this.x;
        const y = this.y;

        let targetX = x;
        let targetY = y;

        // 根据方向计算目标事件的坐标
        switch (direction) {
            case 2: // 下
                targetY += 1;
                break;
            case 4: // 左
                targetX -= 1;
                break;
            case 6: // 右
                targetX += 1;
                break;
            case 8: // 上
                targetY -= 1;
                break;
        }

        // 获取目标坐标上的事件
        const event = $gameMap.eventIdXy(targetX, targetY);

        return event; // 返回目标事件对象，如果没有事件则返回 null
    }

    Game_Character.prototype.getEventBelow = function () {
        const x = this.x;
        const y = this.y;

        return $gameMap.eventIdXy(x, y);
    }

    Game_Player.prototype.checkEventTriggerThere = function (triggers) {
        if (this.canStartLocalEvents()) {
            const direction = this.direction();
            const x1 = this.x;
            const y1 = this.y;
            const x2 = $gameMap.roundXWithDirection(x1, direction);
            const y2 = $gameMap.roundYWithDirection(y1, direction);
            if (triggers.includes(5)) {
                Ve.isTriggeredC = true;
            } else {
                Ve.isTriggeredC = false;
            }
            this.startMapEvent(x2, y2, triggers, true);
            if (!$gameMap.isAnyEventStarting() && $gameMap.isCounter(x2, y2)) {
                const x3 = $gameMap.roundXWithDirection(x2, direction);
                const y3 = $gameMap.roundYWithDirection(y2, direction);
                this.startMapEvent(x3, y3, triggers, true);
            }
        }
    };

    Game_Event.prototype.checkTipCode = function (code) {
        if (!this._erased && this.page()) {
            let check = false;
            this.list().forEach(l => {
                if (l.code === 108) {
                    const comment = l.parameters[0];
                    if (code === comment) {
                        check = true;
                        return;
                    }
                }
            });
            return check;
        }
    }

    Game_Player.prototype.triggerButtonAction = function () {
        if (Input.isTriggered("ok")) {
            if (this.getOnOffVehicle()) {
                return true;
            }
            this.checkEventTriggerHere([0]);
            if ($gameMap.setupStartingEvent()) {
                return true;
            }
            this.checkEventTriggerThere([0, 1, 2]);
            if ($gameMap.setupStartingEvent()) {
                return true;
            }
        } else if (Input.isTriggered("c")) {
            this.checkEventTriggerThere([0, 1, 2, 5]);
            if ($gameMap.setupStartingEvent()) {
                return true;
            }
        }
        return false;
    };

    ImageManager.loadUI = function (filename) {
        return this.loadBitmap("img/ui/", filename);
    };

    // Enable empty name input
    Window_NameInput.prototype.onNameOk = function () {
        this.playOkSound();
        this.callOkHandler();
    };

    // VisuMZ.MessageCore.ParseLocalizationCsv = function (_0x108f37) {
    //     // 将CSV文本按行分割
    //     const _0x4723b8 = _0x108f37.split('\n');
    //     // 获取第一行作为键（列名）
    //     const _0x376df1 = _0x4723b8[0].split(';');
    //     // 遍历剩余行（数据行）
    //     _0x4723b8.slice(1).forEach(_0xa500aa => {
    //         let _0xc481c = [];
    //         let _0x3a323f = '';
    //         let _0x183fb9 = false;
    //         // 逐字符解析每一行
    //         for (let _0x13a4c5 = 0; _0x13a4c5 < _0xa500aa.length; _0x13a4c5++) {
    //             let _0x56be68 = _0xa500aa[_0x13a4c5];
    //             // 处理双引号（用于转义）
    //             if (_0x56be68 === '"')
    //                 _0x183fb9 && _0xa500aa[_0x13a4c5 + 1] === '"' ? (_0x3a323f += _0x56be68, _0x13a4c5++) : _0x183fb9 = !_0x183fb9;
    //             else {
    //                 // 处理分号（分隔符）
    //                 if (_0x56be68 === ';' && !_0x183fb9) {
    //                     _0xc481c.push(_0x3a323f);
    //                     _0x3a323f = '';
    //                 } else
    //                     _0x3a323f += _0x56be68;
    //             }
    //         }
    //         // 处理最后一个字段
    //         if (_0x3a323f)
    //             _0xc481c.push(_0x3a323f);
    //         // 获取第一列的值作为键，并去除双引号和空格
    //         const _0x58321c = _0xc481c[0].replace(/^"|"$/g, '').toLowerCase().trim();
    //         // 将剩余列的值映射到对应的键上
    //         _0x5caf49[_0x58321c] = _0x376df1.slice(1).reduce((_0x568f7e, _0xe2b9a1, _0x34d12b) => {
    //             return _0x568f7e[_0xe2b9a1] = (_0xc481c[_0x34d12b + 1] || '').replace(/^"|"$/g, ''), _0x568f7e;
    //         }, {});
    //     });
    //     // 返回解析后的对象
    //     return _0x5caf49;
    // };

})();