/*:
 * @target MZ
 *
 * @command transferPlayer
 * @text Transfer Player
 * 
 * @arg mapId
 * @text Map ID
 * @type text
 * @default -1
 * 
 * @arg x
 * @text X
 * @type text
 * @default 0
 * 
 * @arg y
 * @text Y
 * @type text
 * @default 0
 * 
 * @arg direction
 * @text Direction
 * @type select
 * @default 0
 * @option Retain
 * @value 0
 * @option Up
 * @value 8
 * @option Down
 * @value 2
 * @option Left
 * @value 4
 * @option Right
 * @value 6
 * 
 * @arg effect
 * @type select
 * @option None
 * @value none
 * @option Black
 * @value 0
 * @option White
 * @value 1
 * @option Zoom
 * @value 3
 * @option Slide Up
 * @value 4
 * @option Slide Left
 * @value 4
 * @option Slide Right
 * @value 4
 * @option Slide Down
 * @value 4
 * @default none
 * 
 */

(() => {
    const pluginName = "TransferEffects";

    const zoomDuration = 50;

    PluginManager.registerCommand(pluginName, "transferPlayer", data => {
        if ($gameParty.inBattle() || $gameMessage.isBusy()) {
            return false;
        }

        let mapId, x, y, d, effect;
        mapId = eval(data.mapId) || 1;
        x = eval(data.x) || 0;
        y = eval(data.y) || 0;
        d = eval(data.direction) || 0;
        effect = Number(data.effect) || 0;

        $gamePlayer.reserveTransfer(mapId, x, y, d, effect);
        // this.setWaitMode("transfer");
    });

    Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
        this._transferring = true;
        this._newMapId = mapId;
        this._newX = x;
        this._newY = y;
        this._newDirection = d;
        this._fadeType = fadeType;
    };

    const _Scene_Map_prototype_initialize = Scene_Map.prototype.initialize;
    Scene_Map.prototype.initialize = function() {
        _Scene_Map_prototype_initialize.call(this);
        this._zoomDuration = 0;
        //0:in 1:out
        this._zoomType = 0;
    }

    const _Scene_Map_prototype_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_prototype_update.call(this);
        this.updateZoomForTransfer();
    }

    Scene_Map.prototype.start = function() {
        Scene_Message.prototype.start.call(this);
        SceneManager.clearStack();
        if (this._transfer) {
            this.fadeInForTransfer();
            this.onTransferEnd();
        } else if (this.needsFadeIn()) {
            this.startFadeIn(this.fadeSpeed(), false);
        }
        this.menuCalling = false;
    };

    Scene_Map.prototype.stop = function() {
        Scene_Message.prototype.stop.call(this);
        $gamePlayer.straighten();
        this._mapNameWindow.close();
        if (this.needsSlowFadeOut()) {
            this.startFadeOut(this.slowFadeSpeed(), false);
        } else if (SceneManager.isNextScene(Scene_Map)) {
            this.fadeOutForTransfer();
        } else if (SceneManager.isNextScene(Scene_Battle)) {
            this.launchBattle();
        }
    };

    Scene_Map.prototype.updateZoomForTransfer = function() {
        if(this._zoomType == 0) {
            if(this._zoomDuration > 0) {
                // console.log(this._zoomDuration);
                this._zoomDuration--;
                const speed = zoomDuration;
                const n = speed - this._zoomDuration;
                const p = n / speed;
                const q = (((p - 1) * 20 * p + 5) * p + 1) * 2;
                const zoomX = $gamePlayer.screenX();
                const zoomY = $gamePlayer.screenY() - 24;
                if (n === 2) {
                    $gameScreen.setZoom(zoomX, zoomY, 1);
                    // this.snapForBattleBackground();
                    // this.startFlashForEncounter(speed / 2);
                }
                $gameScreen.setZoom(zoomX, zoomY, q);
                // if (n === Math.floor(speed / 6)) {
                //     this.startFlashForEncounter(speed / 2);
                // }
                if (n === Math.floor(speed / 2)) {
                    // BattleManager.playBattleBgm();
                    this.startFadeOut(this.fadeSpeed());
                }
            }
        } else {
            if(this._zoomDuration > 0) {
                this._zoomDuration--;
                const zoomX = $gamePlayer.screenX();
                const zoomY = $gamePlayer.screenY() - 24;
                const speed = zoomDuration;
                const n = speed - this._zoomDuration;
                const p = n / speed;
                const q = 2 * (p + this._zoomDuration / speed / 2);
                // console.log(this._zoomDuration);
                $gameScreen.setZoom(zoomX, zoomY, q);
            }
        }
    }

    // Scene_Map.prototype.zoomInForTransfer = function() {
    //     this._zoomDuration = zoomDuration;
    //     this._zoomType = 0;
    // }

    // Scene_Map.prototype.zoomOutForTransfer = function() {
    //     this._zoomDuration = zoomDuration;
    //     this._zoomType = 1;
    // }

    Scene_Base.prototype.isFading = function() {
        return this._fadeDuration > 0 || this._zoomDuration > 0;
    };
    
    Scene_Map.prototype.startZoomOut = function() {
        this._zoomType = 0;
        this._zoomDuration = zoomDuration;
    }

    Scene_Map.prototype.startZoomIn = function() {
        this._zoomType = 1;
        this._zoomDuration = zoomDuration / 3;
        const zoomX = $gamePlayer.screenX();
        const zoomY = $gamePlayer.screenY() - 24;

        this.startFadeIn(this.fadeSpeed());
        $gameScreen.setZoom(zoomX, zoomY, 8);
    }

    Scene_Map.prototype.fadeInForTransfer = function() {
        const fadeType = $gamePlayer.fadeType();
        // console.log(fadeType);
        switch (fadeType) {
            case 0:
            case 1:
                this.startFadeIn(this.fadeSpeed(), fadeType === 1);
                break;
            case 3:
                this.startZoomIn();
                break;
            case 4:
                break;
        }
    };

    Scene_Map.prototype.fadeOutForTransfer = function() {
        const fadeType = $gamePlayer.fadeType();
        switch (fadeType) {
            case 0:
            case 1:
                this.startFadeOut(this.fadeSpeed(), fadeType === 1);
                break;
            case 3:
                this.startZoomOut();
                break;
        }
    };
})();